﻿/*	VERSION:  1.0

USAGE:
	#include "functions/VOW.as"
	#include "functions/VOW/readUrlFile.as"
	readUrlFile( file_path ).then = function( website_url ){
		trace( website_url );
	}// readUrlFile()
	
	#include "functions/VOW.as"
	#include "functions/VOW/loadFile.as"
	#include "functions/VOW/readUrlFile.as"
	loadFile( file_path )
		.then( extractUrl )
		.then( function( website_url ){
			trace( website_url );
		} );
		
	
DESCRIPTION:
	This loads a .URL file and returns the website url stored within it.
	A URL file is created whenever you drag a link out from a web browser.
*/
function readUrlFile( filePath ){
	#include "loadFile.as"
	
	var prom = VOW.make();
	loadFile( filePath )
		.then( extractUrl, prom.doBreak )
		.then( prom.keep, prom.doBreak );
	/*
	loadFile_prom.then = function( file_str ){
		var values_ary = file_str.split('\n');
		// for each line of text
		for(var i in values_ary){
			// if URL info is found
			if( values_ary[i].substr(0,4) === 'URL=' ){
				var url = values_ary[i].substr( 4 );		// get everything after URL=
				prom.keep( url );		// announce the result
				break;		// stop searching
			}// if URL info is found
		}// for each line of text
	}// after loading file()
	*/
	return prom;
}// readUrlFile()


function extractUrl( file_str ){
	var values_ary = file_str.split('\n');
	// for each line of text
	for(var i in values_ary){
		// if URL info is found
		if( values_ary[i].substr(0,4) === 'URL=' ){
			var url = values_ary[i].substr( 4 );		// get everything after URL=
			return url;		// announce the result
			break;		// stop searching
		}// if URL info is found
	}// for each line of text
	// if no URL was found
	return undefined;
}// extractUrl()